# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Eigen decomposition of a matrix in C++.
#'
#' Returns the eigenvalues and eigenvectors of a matrix X.
#'
#' A fast implementation of eigen for symmetric, positive-definite
#' matrices. This helps speed up the I-prior EM algorithm.
#'
#' @param X A symmetric, positive-definite matrix
#'
#' @export
#'
eigenCpp <- function(X) {
    .Call(`_iprior_eigenCpp`, X)
}

#' Multiplying a symmetric matrix by itself in C++.
#'
#' Returns the square of a symmetric matrix X.
#'
#' A fast implementation of X^2 for symmetric matrices. This helps
#' speed up the I-prior EM algorithm.
#'
#' @param X A symmetric matrix
#'
#' @export
#'
fastSquare <- function(X) {
    .Call(`_iprior_fastSquare`, X)
}

fastSquareRoot <- function(X) {
    .Call(`_iprior_fastSquareRoot`, X)
}

#' Computing a quadratic matrix form in C++.
#'
#' Returns XdiagyXT.
#'
#' A fast implementation of XdiagyXT. This helps speed up
#' the I-prior EM algorithm.
#'
#' @param X A symmetric, square matrix of dimension \code{n} by \code{n}
#' @param y A vector of length \code{n}
#'
#' @export
#'
fastVDiag <- function(X, y) {
    .Call(`_iprior_fastVDiag`, X, y)
}

