% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Kernel_functions.R
\name{kernel}
\alias{kernel}
\alias{Canonical}
\alias{FBM}
\alias{Pearson}
\alias{fnH1}
\alias{fnH2}
\alias{fnH3}
\title{Reproducing kernels for the I-prior package}
\usage{
fnH1(x, y = NULL)

fnH2(x, y = NULL)

fnH3(x, y = NULL, gamma = 0.5)
}
\arguments{
\item{x, y}{A vector, matrix or data frame. \code{x} and \code{y} must have
similar dimensions.}

\item{gamma}{The Hurst coefficient when using the FBM kernel.}
}
\value{
A matrix with class of either \code{"Canonical"}, \code{"FBM,gamma"},
  or \code{"Pearson"} whose \code{[i, j]} entries are \eqn{h(}\code{y[i]},
  \code{x[j]}\eqn{)}, with \eqn{h} being the kernel function. The matrix has
  dimensions \code{m} by \code{n} according to the lengths of \code{y} and
  \code{x} which has lengtsh \code{m} and \code{n} respectively. When a
  single vector argument \code{x} is supplied, then \code{y} is taken to be
  equal to \code{x}, and a symmetric \code{n} by \code{n} matrix is returned.

  If \code{x} is a matrix or data frame with \code{p} columns, then the
  kernel matrix returned is \code{fnH(x[, 1]) + ... + fnH(x[, p])}.
}
\description{
The three kernel functions used in this package are the Canonical kernel
\code{fnH2}, Fractional Brownian Motion (FBM) kernel \code{fnH3} (with a
default Hurst coefficient of 0.5), and the Pearson kernel \code{fnH1}.
}
\details{
The Pearson kernel is used for nominal-type variables, and in R,
\code{\link{factor}}-type objects are treated with the Pearson kernel
automatically. The other two kernel types are for continuous variables, with
the Canonical kernel used for "straight-line" effects and the FBM for
smoothing effects. The smoothness is controlled somewhat by the Hurst
coefficient.

More information is available from the \href{https://github.com/haziqjamil/iprior/wiki/Kernel-functions}{Wiki}.
}
\seealso{
The
  \href{https://en.wikipedia.org/wiki/Fractional_Brownian_motion}{Wikipedia}
  page on the Fractional Brownian Motion.
}
