% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{wls}
\alias{wls}
\title{Weighted Least Squares}
\usage{
wls(X, Y, w = NULL, return_se = FALSE)
}
\arguments{
\item{X}{(matrix): n x p matrix of covariates.}

\item{Y}{(vector): p-vector of outcome values.}

\item{w}{(vector, optional): n-vector of sample weights.}

\item{return_se}{(bool, optional): Whether to return the standard errors of
the coefficients.}
}
\value{
(list): A list containing the following:

\describe{
\item{theta}{(vector): p-vector of weighted least squares estimates of
the coefficients.}
\item{se}{(vector): If return_se == TRUE, return the p-vector of
standard errors of the coefficients.}
}
}
\description{
Computes the weighted least squares estimate of the coefficients.
}
\examples{

n <- 1000

X <- rnorm(n, 1, 1)

w <- rep(1, n)

Y <- X + rnorm(n, 0, 1)

wls(X, Y, w = w, return_se = TRUE)

}
