% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppi_plusplus_quantile.R
\name{ppi_plusplus_quantile_est}
\alias{ppi_plusplus_quantile_est}
\title{PPI++ Quantile Estimation (Point Estimate)}
\usage{
ppi_plusplus_quantile_est(
  Y_l,
  f_l,
  f_u,
  q,
  exact_grid = FALSE,
  w_l = NULL,
  w_u = NULL
)
}
\arguments{
\item{Y_l}{(vector): n-vector of labeled outcomes.}

\item{f_l}{(vector): n-vector of predictions in the labeled data.}

\item{f_u}{(vector): N-vector of predictions in the unlabeled data.}

\item{q}{(float): Quantile to estimate. Must be in the range (0, 1).}

\item{exact_grid}{(bool, optional): Whether to compute the exact solution
(TRUE) or an approximate solution based on a linearly spaced grid of 5000
values (FALSE).}

\item{w_l}{(ndarray, optional): Sample weights for the labeled data set.
Defaults to a vector of ones.}

\item{w_u}{(ndarray, optional): Sample weights for the unlabeled
data set. Defaults to a vector of ones.}
}
\value{
(float): Prediction-powered point estimate of the quantile.
}
\description{
Helper function for PPI++ quantile estimation (point estimate)
}
\details{
PPI++: Efficient Prediction Powered Inference (Angelopoulos et al., 2023)
\url{https://arxiv.org/abs/2311.01453}`
}
\examples{

dat <- simdat(model = "quantile")

form <- Y - f ~ 1

Y_l <- dat[dat$set == "labeled", all.vars(form)[1]] |> matrix(ncol = 1)

f_l <- dat[dat$set == "labeled", all.vars(form)[2]] |> matrix(ncol = 1)

f_u <- dat[dat$set == "unlabeled", all.vars(form)[2]] |> matrix(ncol = 1)

ppi_plusplus_quantile_est(Y_l, f_l, f_u, q = 0.5)

}
