% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replicRows.R
\name{replicRows}
\alias{replicRows}
\title{Function to replicate the rows so that each patients' follow-up is split
according to all event times (times parameter)
up to each patient's end time}
\usage{
replicRows(data, tstart, tstop, event, cens, times1, times2, arm)
}
\arguments{
\item{data}{a dataframe containing the following variables}

\item{tstart}{the date of the beginning of the follow-up (in numeric format, with the first being equal at 0)}

\item{tstop}{the date of the end of the follow-up (in numeric format)}

\item{event}{the indicator of failure (a death is denoted by 1 at the end of the follow-up)}

\item{cens}{the indicator of treatment censoring (denoted by 1 at the end of the follow-up)}

\item{times1}{a vector of times (in numeric format) indicating the times according to which
the rows have to be split for patients in the first arm}

\item{times2}{a vector of times (in numeric format) indicating the times according to which
the rows have to be split for patients in the second arm}

\item{arm}{the randomized treatment (2-levels factor)}
}
\value{
a formatted dataframe with the rows replicated according to the provided times parameter
}
\description{
Function to replicate the rows so that each patients' follow-up is split
according to all event times (times parameter)
up to each patient's end time
}
\examples{
# To obtain the times parameter, we can apply the timesTokeep function on the same
# dataframe in the wide format
kept.t <- timesTokeep(toydata, id = "id",
tstart = "randt", tstop = "lastdt",
mes.cov = list(c("ps1", "ps2", "ps3")),
time.cov = list(c("randt", "dt2", "dt3")))
# Now, we can build the long format
toy.long <- wideToLongTDC(data = toydata, id = "id",
tstart = "randt", tstop = "lastdt", event = "status",
bas.cov = c("age", "arm", "swtrtdt"),
mes.cov = list(TDconf = c("ps1", "ps2", "ps3")),
time.cov = list(c("randt", "dt2", "dt3")),
times = kept.t[[1]])
# Put dates in numeric format with tstart at 0
toy.long$tstart <- as.numeric(toy.long$tstart)
toy.long$tstop <- as.numeric(toy.long$tstop)
toy.long$swtrtdt <- as.numeric(toy.long$swtrtdt)
tabi <- split(toy.long, toy.long$id)
L.tabi   <- length(tabi)
tablist <- lapply(1:L.tabi, function(i){
    refstart <- tabi[[i]]$tstart[1]
    tabi[[i]]$tstart  <- tabi[[i]]$tstart - refstart
    tabi[[i]]$tstop <- tabi[[i]]$tstop - refstart
    tabi[[i]]$swtrtdt <- tabi[[i]]$swtrtdt - refstart
    return(tabi[[i]])
    })
    toy.long <- do.call( rbind, tablist )
# Patients are censored when initiating the other arm treatment, that is, at time swtrtdt
toy.long2 <- cens.ipw(toy.long, id = "id", tstart = "tstart", tstop = "tstop",
event = "event", arm = "arm",
realtrt = FALSE, censTime ="swtrtdt")
# We collect all event times (death for both arms and treatment censoring according to the trt arm)
rep.times1 <- unique(c(toy.long2$tstop[toy.long2$cens==1 & toy.long2$arm == "A"],
toy.long2$tstop[toy.long2$event==1]))
rep.times2 <- unique(c(toy.long2$tstop[toy.long2$cens==1 & toy.long2$arm == "B"],
toy.long2$tstop[toy.long2$event==1]))
# to put times in same order as arms levels
levels(toy.long2[, "arm"])
# Now, we can replicate the rows
toy.rep   <- replicRows(toy.long2, tstart = "tstart", tstop = "tstop",
                        event = "event", cens = "cens", 
                        times1 = rep.times1, times2 = rep.times2,
                        arm = "arm")
toy.rep

}
\references{
Graffeo, N., Latouche, A., Le Tourneau C., Chevret, S. (2019) "ipcwswitch: an R package for inverse probability of censoring weighting with an application to switches in clinical trials". Computers in biology and medicine, 111, 103339. doi : "10.1016/j.compbiomed.2019.103339"
}
\seealso{
\code{\link{cens.ipw}}, \code{\link{SHIdat}}, \code{\link{timesTokeep}}, \code{\link{wideToLongTDC}}
}
