% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iota_version_2.R
\name{compute_iota2}
\alias{compute_iota2}
\title{Computes Iota and its elements in version 2}
\usage{
compute_iota2(
  data,
  random_starts = 10,
  max_iterations = 5000,
  cr_rel_change = 1e-12,
  con_step_size = 1e-04,
  con_rel_convergence = 1e-12,
  con_max_iterations = 5000,
  con_random_starts = 5,
  b_min = 0.01,
  fast = TRUE,
  trace = TRUE,
  con_trace = FALSE
)
}
\arguments{
\item{data}{Data for which the elements should be estimated. Data must be
an object of type \code{data.frame} or \code{matrix} with cases in the rows and
raters in the columns.}

\item{random_starts}{An integer for the number of random starts for the
EM algorithm.}

\item{max_iterations}{An integer for the maximum number of iterations within
the EM algorithm.}

\item{cr_rel_change}{Positive numeric value for defining the convergence of the
EM algorithm.}

\item{con_step_size}{\code{Double} for specifying the size for increasing or
decreasing the probabilities during the conditioning stage of estimation.
This value should not be less than 1e-3.}

\item{con_rel_convergence}{\code{Double} for determining the convergence
criterion during the conditioning stage. The algorithm stops if the relative change
is smaller than this criterion.}

\item{con_max_iterations}{\code{Integer} for the maximum number of iterations
during the conditioning stage.}

\item{con_random_starts}{\code{Integer} for the number of random starts
within the conditioning stage.}

\item{b_min}{Value ranging between 0 and 1, determining the minimal size of
the categories for checking if boundary values occurred. The algorithm tries
to select solutions that are not considered to be boundary values.}

\item{fast}{\code{Bool} If \code{TRUE} a fast estimation is applied during the
condition stage. This option ignores all parameters beginning with "con_".
If \code{FALSE} the estimation described in Berding and
Pargmann (2022) is used. Default is \code{TRUE}.}

\item{trace}{\code{TRUE} for printing progress information on the console.
\code{FALSE} if this information is not to be printed.}

\item{con_trace}{\code{TRUE} for printing progress information on the console
during estimations in the conditioning stage. \code{FALSE} if this information
is not to be printed.}
}
\value{
Returns a \code{list} with the following three components:
The first component \code{estimates_categorical_level} comprises all
elements that describe the ratings on a categorical level. The elements are
sub-divided into raw estimates and chance-corrected estimates.
\describe{
\item{\code{raw_estimates}}{
\describe{
\item{\code{alpha_reliability: }}{A vector containing the Alpha
Reliabilities for each category. These values represent probabilities.}
\item{\code{beta_reliability: }}{A vector containing the Beta Reliabilities for each
category. These values represent probabilities.}
\item{\code{assignment_error_matrix: }}{Assignment Error Matrix containing the conditional
probabilities for assigning a unit of category i to categories 1 to n.}
 \item{\code{iota: }}{A vector containing the Iota values for each category.}
 \item{\code{iota_error_1: }}{A vector containing the Iota Error Type I values for each category.}
 \item{\code{iota_error_2: }}{A vector containing the Iota Error Type II values for each category.}
}}

\item{\code{elements_chance_corrected}}{
\describe{
\item{\code{alpha_reliability: }}{A vector containing the chance-corrected Alpha Reliabilities for each category.}
\item{\code{beta_reliability: }}{A vector containing the chance-corrected Beta Reliabilities for each category.}
}}

The second component \code{estimates_scale_level} contains elements for
describing the quality of the ratings on a scale level. It comprises the
following elements:
\describe{
\item{\code{iota_index: }}{The Iota Index, representing the reliability on a scale level.}
\item{\code{iota_index_d4: }}{The Static Iota Index, which is a transformation of the original Iota Index,
in order to consider the uncertainty of estimation.}
\item{\code{iota_index_dyn2: }}{The Dynamic Iota Index, which is a transformation of the original Iota Index,
in order to consider the uncertainty of estimation.}
}

The third component \code{information} contains important information
regarding the parameter estimation. It comprises the following elements:
\describe{
\item{\code{log_likelihood: }}{Log-likelihood of the best solution.}
\item{\code{convergence: }}{If estimation converged 0, otherwise 1.}
\item{\code{est_true_cat_sizes: }}{Estimated categorical sizes. This is the estimated amount of the categories.}
\item{\code{conformity: }}{\code{0} if the solution is in line with assumptions of weak superiority.
 A number greater 0 indicates the number of violations of the assumption
 of weak superiority.}
 \item{\code{random_starts: }}{Numer of random starts for the EM algorithm.}
\item{\code{boundaries: }}{\code{False} if the best solution does not contain boundary values.
\code{True} if the best solution does contain boundary values}
\item{\code{p_boundaries: }}{Percentage of solutions with boundary values during the estimation.}
\item{\code{call: }}{Name of the function that created the object.}
\item{\code{n_rater: }}{Number of raters.}
\item{\code{n_cunits: }}{Number of coding units.}
}}
}
\description{
Fits a model of Iota2 to the data
}
\references{
Florian Berding and Julia Pargmann (2022).Iota Reliability Concept
of the Second Generation. Measures for Content Analysis Done by
Humans or Artificial Intelligences. Berlin: Logos.
https://doi.org/10.30819/5581
}
