% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forward_linkages.R
\name{forward_linkages}
\alias{forward_linkages}
\title{Forward linkages}
\usage{
forward_linkages(output_coefficient_matrix, digits = NULL)
}
\arguments{
\item{output_coefficient_matrix}{An output coefficient matrix created 
with the \code{\link{output_coefficient_matrix_create}} function.}

\item{digits}{Number of decimals for rounding, defaults to \code{NULL}.}
}
\value{
The vector of industry (product) forward linkages in a 
long-form data.frame, containing the metadata column of the the row
names from the \code{output_coefficient_matrix}.
}
\description{
The increased output of a sector indicates that additional
amounts of products are available to be used as inputs by other sectors which can increase their 
production, which is captured in this indicator vector.
}
\details{
Forward linkages as defined by the Eurostat Manual of Supply, Use and
Input-Output Tables (see p506-507.)
}
\examples{
data_table = iotable_get()

de_out <- output_coefficient_matrix_create ( 
 data_table, "tfu", digits = 4
 )

forward_linkages(output_coefficient_matrix = de_out, 
                 digits = 4 )
}
\seealso{
Other linkage functions: 
\code{\link{backward_linkages}()}
}
\concept{linkage functions}
