% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input_coefficient_matrix_create.R
\name{input_coefficient_matrix_create}
\alias{input_coefficient_matrix_create}
\title{Create an input coefficient matrix}
\usage{
input_coefficient_matrix_create(data_table, households = FALSE,
  digits = NULL)
}
\arguments{
\item{data_table}{A symmetric input-output table, a use table, 
a margins or tax table retrieved by the \code{\link{iotable_get}}
 function.}

\item{households}{Defaults to \code{NULL}. Household column can be added 
with \code{TRUE}.}

\item{digits}{An integer showing the precision of the technology matrix in 
digits. Default is \code{NULL} when no rounding is applied.}
}
\value{
A data frame that contains the matrix of first quadrant of the use table as
\code{input_flow} divided by \code{output} supported by a key column of 
product or industries, with a key column. 
Optionally the results are rounded to given \code{digits}.
}
\description{
Create an input coefficient matrix from the input flow matrix and the
output vector. The two input vectors must have consistent labelling, i.e
the same column names must be  found in the use table (input flow) and the
output vector.
}
\details{
The terminology follows the 
\href{http://ec.europa.eu/eurostat/documents/3859598/5902113/KS-RA-07-013-EN.PDF/b0b3d71e-3930-4442-94be-70b36cea9b39?version=1.0}{Eurostat Manual of Supply, Use and Input-Output Tables}.
Input-Output Multipliers Specification Sheet and Supporting Material, Spicosa Project Report, 
which cannot be linked due to a malformatted url, but can be found with a search engine.
this matrix is called 'technological coefficients'. The results of the function are 
tested on both sources.

This is a wrapper function around  \code{\link{coefficient_matrix_create}}.
}
\examples{
input_coefficient_matrix_create ( 
                           iotable_get(), 
                           digits = 4 )
                           
#This is a wrapper function and equivalent to                           

coefficient_matrix_create( iotable_get(), 
                           total = "total", 
                           return = "products")
}
