% Generated by roxygen2 (4.0.1): do not edit by hand
\name{qwrite}
\alias{qwrite}
\title{Data output}
\usage{
qwrite(x, file, type = NULL, ...)
}
\arguments{
\item{x}{data object to write}

\item{file}{filename (character or \code{filename::filename}),
a readable text-mode connection (for some types),
or path to existing directory}

\item{type}{data or file type}

\item{...}{other arguments passed to the underlying function}
}
\value{
a data object (object type depends on the underlying function)
}
\description{
This function writes an object to file in a specified format.
}
\details{
If \code{type} is \code{NULL}, the file type is inferred from
the file extension. If \code{type} is \code{NA} or if the file extension is
unavailable or unknown, \code{type} is inferred from \code{class(x)}.
Use \code{\link{io_supported}} to check support for a file or data type.
}
\examples{
\dontrun{
data(cars);

# write data to a TSV file
qwrite(cars, "cars.tsv");
# infer output type based on the class of the cars object
qwrite(as.matrix(cars), "cars.mtx", type=NA);
}
}

