% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_min_max_dynamic.R
\name{sim_min_max_dynamic}
\alias{sim_min_max_dynamic}
\title{sim_min_max_dynamic}
\usage{
sim_min_max_dynamic(
  demand,
  forecast,
  leadtime,
  service_level,
  initial_inventory_level = FALSE,
  Max_to_min = 1.5,
  Max = FALSE,
  one_step_forecast = TRUE,
  shortage_cost = FALSE,
  inventory_cost = FALSE,
  ordering_cost = FALSE,
  distribution = "normal",
  error_metric = "mse",
  smoothing_error = 0.2,
  metric_windows = FALSE,
  plot = FALSE,
  Backlogs = FALSE
)
}
\arguments{
\item{demand}{A vector of demand in N time periods.}

\item{forecast}{the forecast vector of equal n periods to demand.}

\item{leadtime}{lead time from order to arrival (order to delivery time)}

\item{service_level}{cycle service level requested}

\item{initial_inventory_level}{integer,Default is False and simulation starts with min as inventory level}

\item{Max_to_min}{numeric, the ratio of Max to min calculation , default 1.3 but can be changed manually.}

\item{Max}{integer,Default is False and max is calculated as a ratio to min,otherwise set manually.}

\item{one_step_forecast}{logical, Default is true where demand lead time is calcluated as(forecast at period t * leadtime)
while if False, demand
leadtime is calculated as (forecast of period t to forecast of period t+leadtime-1)}

\item{shortage_cost}{numeric,Default is FALSE shortage cost per unit of sales lost}

\item{inventory_cost}{numeric,Default is FALSE inventory cost per unit.}

\item{ordering_cost}{numeric,Default is FALSE ordering cost for every time an order is made.}

\item{distribution}{distribution  to calculate safety stock based on demand distribution, current choices are 'normal'
'poisson','gamma' and negative binomial 'nbinom'}

\item{error_metric}{metric is currently 'rmse' and 'mae', this calculates the error from period 1 to period t unless metric_windows is set.
this contributes to the calculation of saftey stock. default is 'rmse'}

\item{smoothing_error}{number between 0 and 1 to smooth the error as alpha x error[t] + (1-alpha) x error t-1, if metric_windows is used, smoothing 
error has to be FALSE}

\item{metric_windows}{integer, for exammple if it is set to 4 rmse for t is calculated from t-1 to t-4,default is FALSE}

\item{plot}{Logical, Default is False, if true a plot is generated}

\item{Backlogs}{Logical, Default is False, if true inventory level accounts for previous lost orders}
}
\value{
a list of two date frames, the simulation and the metrics. the metrics are (1) shortage cost, (2) inventory cost which
is the cost of one unit of inventory in one period,(3) which is the average inventory level per period, (4) total orders made in the 
simulation, (5) ordering cost if any, (6) total lost sales if any,(7) average ordering quantity across all orders,(8) ordering
interval which is the average time between each order,(9) item fill rate,(10) cycle service level, (11) average saftey stock in each
period,(12) the average sales in every order,(13) overall root mean square error, (14) overall mean absolute error, 
(14) overall mean  error,(15) overall mean absolute percentage error,(16) the average flowttime which is the average time 
a unit spends on inventory and (17) the demand classification.
}
\description{
Simulating a min max policy or also called s,S policy, 
the Max is dynamically calculated based on a forecast vector. .
The Function takes a demand vector, mean of demand ,sd,lead time and requested service level to simulate an inventory system, 
orders are lost if inventory level is less than requested demand, also ordering is made at
 day t+1, metrics like item fill rate and cycle service level are calculated. 
 the min is calculated based on a normal distribution or a poisson distribution, also min can be set manually.
 Max - inventory position is ordered whenever inventory position reaches min
}
\examples{
sim_min_max_dynamic(demand = rpois(90,6),forecast = rpois(90,6),
leadtime = 6,service_level = 0.95,one_step_forecast  = FALSE,Max = 80,
distribution = 'normal',error_metric = 'mae',Backlogs=TRUE)
}
\author{
"haytham omar  email: <haytham@rescaleanalytics.com>"
}
