% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/periodic_policy.R
\name{periodic_policy}
\alias{periodic_policy}
\title{periodic_policy}
\usage{
periodic_policy(
  demand,
  mean = FALSE,
  sd = FALSE,
  leadtime,
  service_level,
  initial_inventory_level = FALSE,
  Max = FALSE,
  Review_period,
  shortage_cost = FALSE,
  inventory_cost = FALSE,
  ordering_cost = FALSE,
  distribution = "normal",
  recalculate = FALSE,
  recalculate_windows = FALSE,
  plot = FALSE
)
}
\arguments{
\item{demand}{A vector of demand in N time periods.}

\item{mean}{average demand in N time periods.default is FALSE and is automatically calculated. otherwise set manually.}

\item{sd}{standard deviation in N time periods.default is FALSE and is automatically calculated. otherwise set manually.}

\item{leadtime}{lead time from order to arrival (order to delivery time)}

\item{service_level}{cycle service level requested}

\item{initial_inventory_level}{integer,Default is False and simulation starts with min as inventory level}

\item{Max}{integer,Default is False and max is calculated as a ratio to min,otherwise set manually.}

\item{Review_period}{Integer, the number of periods where every order is allowed to be made.}

\item{shortage_cost}{numeric,Default is FALSE shortage cost per unit of sales lost}

\item{inventory_cost}{numeric,Default is FALSE inventory cost per unit.}

\item{ordering_cost}{numeric,Default is FALSE ordering cost for every time an order is made.}

\item{distribution}{distribution  to calculate safety stock based on demand distribution, current choices are 'normal' or 'poisson'}

\item{recalculate}{integer, the mean and sd is recalculated every X periods from first period to x,default is FALSE .}

\item{recalculate_windows}{integer, the min  mean and sd windows to recalculate , for exammple if it is set to 4 mean and sd
is calculated from t to t-4,,default is FALSE .}

\item{plot}{Logical, Default is False, if true a plot is generated}
}
\value{
a list of two date frames, the simulation and the metrics.
}
\description{
Simulating a  periodic policy, different from R,s,S because here order is made at the ordering time without a min(reordering quantity)
}
\details{
The Function takes a demand vector, mean of demand ,sd,lead time and requested service level to simulate an inventory system, 
orders are lost if inventory level is less than requested demand, also ordering is made at
 day t+1, metrics like item fill rate and cycle service level are calculated. 
 the min is calculated based on a normal distribution or a poisson distribution, also min can be set manually.
 Max - inventory position is ordered  at the period of review
}
\examples{
periodic_policy(demand = rpois(90,9),service_level = 0.9,
leadtime = 10,Review_period = 10,recalculate = 9)
}
\author{
"haytham omar  email: <haytham@rescaleanalytics.com>"
}
