% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sim_min_Q_pois.R
\name{sim_min_Q_pois}
\alias{sim_min_Q_pois}
\title{sim_min_Q_pois}
\usage{
sim_min_Q_pois(
  demand,
  lambda,
  leadtime,
  service_level,
  Quantity,
  shortage_cost = FALSE,
  inventory_cost = FALSE
)
}
\arguments{
\item{demand}{A vector of demand in N time periods.}

\item{lambda}{rate of demand in N time periods.}

\item{leadtime}{lead time from order to arrival}

\item{service_level}{cycle service level requested}

\item{Quantity}{Fixed order quantity to be ordered at min}

\item{shortage_cost}{shortage cost per unit of sales lost}

\item{inventory_cost}{inventory cost per unit.}
}
\value{
a list of two date frames, the simulation and the metrics.
}
\description{
Simulating a Min,Q policy or also calleD S,Q policy,  .
}
\details{
The Function takes a demand vector, mean of demand ,sd,lead time and requested service level to simulate and inventory system, 
orders are lost if inventory level is less than requested demand, also ordering is made at
 day t+1, metrics like item fill rate and cycle service level are calculated. the min is calculated based on a normal distribution.
}
\examples{
sim_min_Q_pois(demand = rpois(50,8),lambda = 4,leadtime = 4,shortage_cost =30,
 Quantity = 12,service_level = 0.70,
inventory_cost = 50)
}
\author{
"haytham omar  email: <haytham@rescaleanalytics.com>"
}
