% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genericfunctions.R
\name{plot.invacost.costsummary}
\alias{plot.invacost.costsummary}
\title{Plot raw cumulated cost of invasive species over different periods of time}
\usage{
\method{plot}{invacost.costsummary}(
  x,
  plot.breaks = 10^(-15:15),
  plot.type = "points",
  average.annual.values = TRUE,
  cost.transf = "log10",
  graphical.parameters = NULL,
  ...
)
}
\arguments{
\item{x}{The output object from \code{\link{summarizeCosts}}}

\item{plot.breaks}{a vector of numeric values indicating the plot breaks 
for the Y axis (cost values)}

\item{plot.type}{\code{"points"} or \code{"bars"}. Defines the type of plot
you want to make; bars are not advised in log scale because the base value (0)
is infinite in log-scale.}

\item{average.annual.values}{if \code{TRUE}, the plot will represent average
annual values rather than cumulative values over the entire period}

\item{cost.transf}{Type of transformation you want to apply on cost values.
Specify \code{NULL} to avoid any transformation. Only useful
for graphical representation.}

\item{graphical.parameters}{set this to \code{"manual"} if you want to 
customise \code{ggplot2} parameters. 
By default, the following layers are configured: \code{ylab}, \code{xlab}, 
\code{scale_x_continuous},
\code{theme_bw} and, if \code{cost.transf = "log10"}, \code{scale_y_log10} and 
\code{annotation_logticks}. If you specify \code{grahical.parameters = "manual"},
all defaults will be ignored.}

\item{...}{additional arguments, none implemented for now}
}
\description{
This function provides different plotting methods for the raw average annual 
cost of invasive species over different periods of time
}
\examples{
data(invacost)

### Cleaning steps
# Eliminating data with no information on starting and ending years
invacost <- invacost[-which(is.na(invacost$Probable_starting_year_adjusted)), ]
invacost <- invacost[-which(is.na(invacost$Probable_ending_year_adjusted)), ]
# Keeping only observed and reliable costs
invacost <- invacost[invacost$Implementation == "Observed", ]
invacost <- invacost[which(invacost$Method_reliability == "High"), ]
# Eliminating data with no usable cost value
invacost <- invacost[-which(is.na(invacost$Cost_estimate_per_year_2017_USD_exchange_rate)), ]

### Expansion
\donttest{
db.over.time <- expandYearlyCosts(invacost,
                                  startcolumn = "Probable_starting_year_adjusted",
                                  endcolumn = "Probable_ending_year_adjusted")
                                  
### Analysis
res <- summarizeCosts(db.over.time,
                      minimum.year = 1970,
                      maximum.year = 2020)

### Visualisation
plot(res)
plot(res, plot.type = "bars")
}
}
\references{
\url{https://github.com/Farewe/invacost}

Leroy Boris, Kramer Andrew M, Vaissière Anne-Charlotte, Courchamp Franck & Diagne Christophe (2020). Analysing global economic costs of invasive alien species with the
invacost R package. biorXiv. \doi{10.1101/2020.12.10.419432}
}
