% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/asIgraph.R
\name{asIgraph}
\alias{asIgraph}
\alias{asIgraph.data.frame}
\alias{asIgraph.network}
\title{Coerce an object to class "igraph"}
\usage{
asIgraph(x, ...)

\method{asIgraph}{network}(x, amap = attrmap(), ...)

\method{asIgraph}{data.frame}(x, directed = TRUE, vertices = NULL,
  vnames = NULL, ...)
}
\arguments{
\item{x}{R object to be converted}

\item{amap}{data.frame with attribute copy/rename rules, see
\code{\link{attrmap}}}

\item{directed}{logical, whether the created network should be directed}

\item{vertices}{NULL or data frame, optional data frame containing vertex
attributes}

\item{vnames}{character, name of the column in \code{vertices} to be used as
a \code{name} vertex attribute, if \code{NULL} no vertex names are created}

\item{\dots}{other arguments from/to other methods}
}
\value{
Object of class "igraph".
}
\description{
Coerce objects to class "igraph".
}
\details{
\code{asIgraph} is a generic function with methods written for data frames
and objects of class "network".

If \code{x} is a data frame, the method used is a wrapper around
\code{\link[igraph]{graph.data.frame}} in package \pkg{igraph}. The
\code{vnames} argument was added so that the user can specify which vertex
attribute from the data frame supplied through \code{vertices} argument is
used for vertex names (the \code{name} attribute in \code{igraph} objects) in
the returned result. By default the vertex names are not created.

If \code{x} is of class "network" (package \pkg{network}) the function
uses \code{\link{asDF}} to extract data on edges and vertex with their
attributes (if present).  Network attributes are extracted as well. Not all
vertex/edge/network attributes are worth preserving though. Attributes are
copied, dropped or renamed based on rules given in the \code{amap}
argument, see \code{\link{attrmap}} for details. The function currently does
not support objects that represent neither bipartite networks nor
hypergraphs.
}
\examples{
### using 'asIgraph' on objects of class 'network'

g <- asIgraph(exNetwork)

# compare adjacency matrices
netmat <- as.matrix(exNetwork, "adjacency")
imat <- as.matrix(g, "adjacency")
# drop the dimnames in 'netmat'
dimnames(netmat) <- NULL
# compare
identical( netmat, imat )


### using 'asIgraph' on data.frames

# data frame with vertex ids and vertex attributes
v <- 1:4
vd <- data.frame(id = v + 5, label=letters[1:4])
print(vd)

# edge list (first two columns) and edge attributes
e <- c(1,2, 2,3, 3,4, 4,1)
ed <- data.frame(id1 = e[seq(1,8, by=2)]+5, id2=e[seq(2, 8, by=2)]+5, a=letters[1:4])
print(ed)

# build the network
# without vertex attributes
g <- asIgraph(ed, directed=FALSE)
# with vertex attributes
gv <- asIgraph(ed, vertices=vd, directed=FALSE)

# NOTE: Even though vertex ids start at 6 the network has 4 nodes:
range(vd$id) # min and max of node ids
if(require(igraph)) igraph::vcount(gv) # number of nodes in 'gv'
}
\seealso{
\code{\link[igraph]{graph.data.frame}}
}

