% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intensitynet.R
\name{NodeGeneralCorrelation.intensitynet}
\alias{NodeGeneralCorrelation.intensitynet}
\title{It allows to compute different dependence statistics on the network
for the given vector and for neighborhoods of distinct order. Such statistics are; correlation,
covariance, Moran’s I and Geary’s C.}
\usage{
\method{NodeGeneralCorrelation}{intensitynet}(
  obj,
  dep_type,
  lag_max,
  intensity,
  partial_neighborhood = TRUE
)
}
\arguments{
\item{obj}{intensitynet object}

\item{dep_type}{'correlation', 'covariance', moran', 'geary'. The type of 
dependence statistic to be computed.}

\item{lag_max}{Maximum geodesic lag at which to compute dependence}

\item{intensity}{Vector containing the values to calculate the specified dependency in the network. Usually the node mean intensities.}

\item{partial_neighborhood}{use partial neighborhood (TRUE) or cumulative (FALSE). TRUE by default}
}
\value{
A vector containing the dependence statistics (ascending from order 0).
}
\description{
It allows to compute different dependence statistics on the network
for the given vector and for neighborhoods of distinct order. Such statistics are; correlation,
covariance, Moran’s I and Geary’s C.
}
\examples{

data("und_intnet_chicago")
g <- und_intnet_chicago$graph
gen_corr <- NodeGeneralCorrelation(und_intnet_chicago, dep_type = 'correlation', lag_max = 2, 
                                   intensity = igraph::vertex_attr(g)$intensity)

}
