% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bam2counts.R
\name{bam2counts}
\alias{bam2counts}
\title{Compute the number of reads fall into specific genomic region}
\usage{
bam2counts(bamFile, region, fragLength = 180)
}
\arguments{
\item{bamFile}{Aligned bam file as input.}

\item{region}{The GRanges object defined by user to calculate the number of reads fall into
this specific region. For ChIP-Seq of histone modifications they are usually
promoter, enhancer and genebody regions.}

\item{fragLength}{Extend reads toward the 3'-end to the average DNA fragment size obtained
after DNA size selection}
}
\value{
a vector of numbers
}
\description{
\code{bam2counts} computes the number of reads fall into specific genomic
region such as promoter, enhancer, genebody
}
\examples{
data("promoter")
file.bam <- system.file("extdata", "SRR925640.bam", package = "intePareto")
bam2counts(bamFile = file.bam, region = promoter, fragLength = 180)
}
