% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariate_5avgpremium.R
\name{univariate_average_premium}
\alias{univariate_average_premium}
\title{Univariate average premium}
\usage{
univariate_average_premium(
  df,
  x,
  premium,
  exposure,
  nclaims = NULL,
  severity = NULL
)
}
\arguments{
\item{df}{data.frame with insurance portfolio}

\item{x}{column in \code{df} with risk factor}

\item{premium}{column in \code{df} with premium (default is NULL)}

\item{exposure}{column in \code{df} with exposure}

\item{nclaims}{column in \code{df} with number of claims}

\item{severity}{column in \code{df} with severity (default is NULL)}
}
\value{
An list of class \code{univ_lossratio} with components
\item{df}{data frame with average premium}
\item{xvar}{name of column in df with risk factor}
\item{severity}{name of column in df with severity}
\item{nclaims}{name of column in df with number of claims}
\item{exposure}{name of column in df with exposure}
\item{premium}{name of column in df with premium}
}
\description{
Average premium for discrete risk factors in an insurance portfolio. For each level of the risk factor the average premium is equal to the ratio between the premium and the exposure.
}
\examples{
univariate_average_premium(MTPL2, x = area, premium = premium, exposure = exposure)
}
\author{
Martin Haringa
}
