stan_test("stan_package_create()", {
  skip_cmdstan()
  temp <- tempfile()
  dir.create(temp)
  stan_package_configure(path = temp)
  cleanup <- file.path(temp, "cleanup")
  cleanup_win <- file.path(temp, "cleanup.win")
  makevars <- file.path(temp, "src", "Makevars")
  makevars_win <- file.path(temp, "src", "Makevars.win")
  expect_true(file.exists(cleanup))
  expect_true(file.exists(cleanup_win))
  expect_true(file.exists(makevars))
  expect_true(file.exists(makevars_win))
  lines_cleanup <- paste(readLines(cleanup), collapse = "\n")
  lines_cleanup_win <- paste(readLines(cleanup_win), collapse = "\n")
  expect_false(any(lines_cleanup == lines_cleanup_win))
})
