% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_weights.R
\name{get_weights}
\alias{get_weights}
\alias{get_weights.default}
\title{Get the values from model weights}
\usage{
get_weights(x, ...)

\method{get_weights}{default}(x, remove_na = FALSE, null_as_ones = FALSE, na_rm = remove_na, ...)
}
\arguments{
\item{x}{A fitted model.}

\item{...}{Currently not used.}

\item{remove_na}{Logical, if \code{TRUE}, removes possible missing values.}

\item{null_as_ones}{Logical, if \code{TRUE}, will return a vector of \code{1}
if no weights were specified in the model (as if the weights were all set
to 1).}

\item{na_rm}{Deprecated, use \code{remove_na} instead.}
}
\value{
The weighting variable, or \code{NULL} if no weights were specified.
If the weighting variable should also be returned (instead of \code{NULL})
when all weights are set to 1 (i.e. no weighting),
set \code{null_as_ones = TRUE}.
}
\description{
Returns weighting variable of a model.
}
\examples{
data(mtcars)
set.seed(123)
mtcars$weight <- rnorm(nrow(mtcars), 1, .3)

# LMs
m <- lm(mpg ~ wt + cyl + vs, data = mtcars, weights = weight)
get_weights(m)

get_weights(lm(mpg ~ wt, data = mtcars), null_as_ones = TRUE)

# GLMs
m <- glm(vs ~ disp + mpg, data = mtcars, weights = weight, family = quasibinomial)
get_weights(m)
m <- glm(cbind(cyl, gear) ~ mpg, data = mtcars, weights = weight, family = binomial)
get_weights(m)
}
