% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{get_data}
\alias{get_data}
\alias{get_data.default}
\alias{get_data.glmmTMB}
\alias{get_data.afex_aov}
\title{Get the data that was used to fit the model}
\usage{
get_data(x, ...)

\method{get_data}{default}(x, verbose = TRUE, ...)

\method{get_data}{glmmTMB}(x, effects = "all", component = "all", verbose = TRUE, ...)

\method{get_data}{afex_aov}(x, shape = c("long", "wide"), ...)
}
\arguments{
\item{x}{A fitted model.}

\item{...}{Currently not used.}

\item{verbose}{Toggle messages and warnings.}

\item{effects}{Should model data for fixed effects (\code{"fixed"}), random
effects (\code{"random"}) or both (\code{"all"}) be returned? Only applies to mixed
or gee models.}

\item{component}{Should all predictor variables, predictor variables for the
conditional model, the zero-inflated part of the model, the dispersion
term or the instrumental variables be returned? Applies to models
with zero-inflated and/or dispersion formula, or to models with instrumental
variable (so called fixed-effects regressions). May be abbreviated. Note that the
\emph{conditional} component is also called \emph{count} or \emph{mean}
component, depending on the model.}

\item{shape}{Return long or wide data? Only applicable in repeated measures
designs.}
}
\value{
The data that was used to fit the model.
}
\description{
This functions tries to get the data that was used to fit the
model and returns it as data frame.
}
\note{
Unlike \code{model.frame()}, which may contain transformed variables
(e.g. if \code{poly()} or \code{scale()} was used inside the formula to
specify the model), \code{get_data()} aims at returning the "original",
untransformed data (if possible). Consequently, column names are changed
accordingly, i.e. \code{"log(x)"} will become \code{"x"} etc. for all data
columns with transformed values.
}
\section{Model components}{

Possible values for the \code{component} argument depend on the model class.
Following are valid options:
\itemize{
\item \code{"all"}: returns all model components, applies to all models, but will only
have an effect for models with more than just the conditional model component.
\item \code{"conditional"}: only returns the conditional component, i.e. "fixed effects"
terms from the model. Will only have an effect for models with more than
just the conditional model component.
\item \code{"smooth_terms"}: returns smooth terms, only applies to GAMs (or similar
models that may contain smooth terms).
\item \code{"zero_inflated"} (or \code{"zi"}): returns the zero-inflation component.
\item \code{"dispersion"}: returns the dispersion model component. This is common
for models with zero-inflation or that can model the dispersion parameter.
\item \code{"instruments"}: for instrumental-variable or some fixed effects regression,
returns the instruments.
\item \code{"location"}: returns location parameters such as \code{conditional},
\code{zero_inflated}, \code{smooth_terms}, or \code{instruments} (everything that are
fixed or random effects - depending on the \code{effects} argument - but no
auxiliary parameters).
\item \code{"distributional"} (or \code{"auxiliary"}): components like \code{sigma}, \code{dispersion},
\code{beta} or \code{precision} (and other auxiliary parameters) are returned.
}
}

\examples{
if (require("lme4")) {
  data(cbpp, package = "lme4")
  cbpp$trials <- cbpp$size - cbpp$incidence
  m <- glm(cbind(incidence, trials) ~ period, data = cbpp, family = binomial)
  head(get_data(m))
}
}
