% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_parameters_emmeans.R
\name{find_parameters.emmGrid}
\alias{find_parameters.emmGrid}
\title{Find model parameters from estimated marginal means objects}
\usage{
\method{find_parameters}{emmGrid}(x, flatten = FALSE, merge_parameters = FALSE, ...)
}
\arguments{
\item{x}{A fitted model.}

\item{flatten}{Logical, if \code{TRUE}, the values are returned
as character vector, not as list. Duplicated values are removed.}

\item{merge_parameters}{Logical, if \code{TRUE} and \code{x} has multiple
columns for parameter names (like \code{emmGrid} objects may have), these
are merged into a single parameter column, with parameters names and values
as values.}

\item{...}{Currently not used.}
}
\value{
A list of parameter names. For simple models, only one list-element,
   \code{conditional}, is returned.
}
\description{
Returns the parameter names from a model.
}
\examples{
data(mtcars)
model <- lm(mpg ~ wt * factor(cyl), data = mtcars)
if (require("emmeans", quietly = TRUE)) {
  emm <- emmeans(model, c("wt", "cyl"))
  find_parameters(emm)
}
}
