% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_table.R
\name{export_table}
\alias{export_table}
\alias{format_table}
\title{Data frame and Tables Pretty Formatting}
\usage{
export_table(
  x,
  sep = " | ",
  header = "-",
  digits = 2,
  protect_integers = TRUE,
  missing = "",
  width = NULL,
  format = NULL,
  caption = NULL,
  subtitle = NULL,
  align = NULL,
  footer = NULL,
  zap_small = FALSE
)

format_table(
  x,
  sep = " | ",
  header = "-",
  digits = 2,
  protect_integers = TRUE,
  missing = "",
  width = NULL,
  format = NULL,
  caption = NULL,
  subtitle = NULL,
  align = NULL,
  footer = NULL,
  zap_small = FALSE
)
}
\arguments{
\item{x}{A data frame.}

\item{sep}{Column separator.}

\item{header}{Header separator. Can be \code{NULL}.}

\item{digits}{Number of significant digits.}

\item{protect_integers}{Should integers be kept as integers (i.e., without decimals)?}

\item{missing}{Value by which \code{NA} values are replaced. By default, an empty string (i.e. \code{""}) is returned for \code{NA}.}

\item{width}{Minimum width of the returned string. If not \code{NULL} and \code{width} is larger than the string's length, leading whitespaces are added to the string.}

\item{format}{Name of output-format, as string. If \code{NULL} (or \code{"text"}),
returned output is used for basic printing. Currently, only \code{"markdown"} is
supported, or \code{NULL} (the default) resp. \code{"text"} for plain text.}

\item{caption, subtitle}{Table caption and subtitle, as string. If \code{NULL},
no caption or subtitle is printed.}

\item{align}{Column alignment. Only applies to markdown-formatted tables.
By default \code{align = NULL}, numeric columns are right-aligned,
and other columns are left-aligned. May be a string to indicate alignment
rules for the complete table, like \code{"left"}, \code{"right"},
\code{"center"} or \code{"firstleft"} (to left-align first column,
center remaining); or maybe a string with abbreviated alignment characters,
where the length of the string must equal the number of columns, for
instance, \code{align = "lccrl"} would left-align the first column, center
the second and third, right-align column four and left-align the fifth
column.}

\item{footer}{Table footer, as string. For markdown-formatted tables, table
footers, due to the limitation in markdown rendering, are actually just a
new text line under the table.}

\item{zap_small}{Logical, if \code{TRUE}, small values are rounded after \code{digits} decimal places. If \code{FALSE}, values with more decimal places than \code{digits} are printed in scientific notation.}
}
\value{
A data frame in character format.
}
\description{
Data frame and Tables Pretty Formatting
}
\note{
This function is going to be renamed in a future update. Please use its
alias \code{export_table()}.
}
\examples{
cat(export_table(iris))
cat(export_table(iris, sep = " ", header = "*", digits = 1))
}
