% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_sigma.R
\name{get_sigma}
\alias{get_sigma}
\title{Get residual standard deviation from models}
\usage{
get_sigma(x)
}
\arguments{
\item{x}{A model.}
}
\value{
The residual standard deviation (sigma), or \code{NULL} if this information could not be accessed.
}
\description{
Returns the residual standard deviation from classical
  and mixed models.
}
\details{
The residual standard deviation, \ifelse{html}{\out{&sigma;}}{\eqn{\sigma}},
  indicates that the predicted outcome will be within +/- \ifelse{html}{\out{&sigma;}}{\eqn{\sigma}}
  units of the linear predictor for approximately 68\% of the data points
  (\cite{Gelman, Hill & Vehtari 2020, p.84}). In other words, the residual
  standard deviation indicates the accuracy for a model to predict scores,
  thus it can be thought of as \dQuote{a measure of the average distance
  each observation falls from its prediction from the model}
  (\cite{Gelman, Hill & Vehtari 2020, p.168}). \ifelse{html}{\out{&sigma;}}{\eqn{\sigma}}
  can be considered as a measure of the unexplained variation in the data,
  or of the precision of inferences about regression coefficients.
}
\examples{
data(mtcars)
m <- lm(mpg ~ wt + cyl + vs, data = mtcars)
get_sigma(m)
}
\references{
Gelman, A., Hill, J., & Vehtari, A. (2020). Regression and Other Stories. Cambridge University Press.
}
