% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_ci.R
\name{format_ci}
\alias{format_ci}
\title{Confidence/Credible Interval (CI) Formatting}
\usage{
format_ci(
  CI_low,
  CI_high,
  ci = 0.95,
  digits = 2,
  brackets = TRUE,
  width = NULL,
  width_low = width,
  width_high = width,
  missing = ""
)
}
\arguments{
\item{CI_low}{Lower CI bound.}

\item{CI_high}{Upper CI bound.}

\item{ci}{CI level in percentage.}

\item{digits}{Number of significant digits.}

\item{brackets}{Logical, if \code{TRUE} (default), values are encompassed in square brackets.}

\item{width}{Minimum width of the returned string. If not \code{NULL} and \code{width} is larger than the string's length, leading whitespaces are added to the string. If \code{width="auto"}, width will be set to the length of the longest string.}

\item{width_low, width_high}{Like \code{width}, but only applies to the lower or higher confidence interval value. This can be used when the values for the lower and upper CI are of very different length.}

\item{missing}{Value by which \code{NA} values are replaced. By default, an empty string (i.e. \code{""}) is returned for \code{NA}.}
}
\value{
A formatted string.
}
\description{
Confidence/Credible Interval (CI) Formatting
}
\examples{
format_ci(1.20, 3.57, ci = 0.90)
format_ci(1.20, 3.57, ci = NULL)
format_ci(1.20, 3.57, ci = NULL, brackets = FALSE)
format_ci(c(1.205645, 23.4), c(3.57, -1.35), ci = 0.90)
format_ci(c(1.20, NA, NA), c(3.57, -1.35, NA), ci = 0.90)

# automatic alignment of width, useful for printing multiple CIs in columns
x <- format_ci(c(1.205, 23.4, 100.43), c(3.57, -13.35, 9.4))
cat(x, sep = "\n")

x <- format_ci(c(1.205, 23.4, 100.43), c(3.57, -13.35, 9.4), width = "auto")
cat(x, sep = "\n")
}
