% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_parameters.R
\name{find_parameters}
\alias{find_parameters}
\title{Find names of model parameters}
\usage{
find_parameters(x, ...)
}
\arguments{
\item{x}{A fitted model.}

\item{...}{Currently not used.}
}
\value{
A list of parameter names. For simple models, only one list-element,
   \code{conditional}, is returned. For more complex models, the returned
   list may have following elements:
   \itemize{
     \item \code{conditional}, the "fixed effects" part from the model
     \item \code{random}, the "random effects" part from the model
     \item \code{zero_inflated}, the "fixed effects" part from the zero-inflation component of the model
     \item \code{zero_inflated_random}, the "random effects" part from the zero-inflation component of the model
     \item \code{dispersion}, the dispersion formula
     \item \code{within}, the within-subject effects of Anovas (\code{aov()}) with error term
     \item \code{between}, the between-subjects effects of Anovas (\code{aov()}) with error term
   }
}
\description{
Returns the names of model parameters, like they typically
    appear in the \code{summary()} output. For Bayesian models, the parameter
    names equal the column names of the posterior samples after coercion
    from \code{as.data.frame()}.
}
\examples{
data(mtcars)
m <- lm(mpg ~ wt + cyl + vs, data = mtcars)
find_parameters(m)
}
