% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date.R
\name{inline_date}
\alias{inline_date}
\title{Inline date input with calendar}
\usage{
inline_date(
  id,
  value = NULL,
  min = NULL,
  max = NULL,
  placeholder = "Enter date",
  meaning = NULL,
  format = "yyyy-mm-dd",
  startview = "month",
  weekstart = 0,
  language = "en",
  autoclose = TRUE,
  datesdisabled = NULL,
  daysofweekdisabled = NULL
)
}
\arguments{
\item{id}{The \code{input} slot that will be used to access the value.}

\item{value}{The initially selected date. Either a Date object; a
character string in \code{"yyyy-mm-dd"} format (\emph{not} in the calendar's
display format); or \code{NULL} to use the current date in the client's
time zone.}

\item{min, max}{The minimum and maximum allowed date. Either a Date object,
a character string in \code{"yyyy-mm-dd"} format, or \code{NULL} for no limit.}

\item{placeholder}{The character string or HTML element that will appear in
the textbox when it is empty, as a prompt.}

\item{meaning}{A descriptive label, for people using assistive technology
such as screen readers.}

\item{format}{The format of the date to display in the browser; defaults to
"yyyy-mm-dd". Note that this is only for display purposes. Changing the
display format does not allow you to specify \code{value}, \code{min}, \code{max}, or
\code{datesdisabled} in that format; those have to stay formatted as
\code{"yyyy-mm-dd"} or as Date objects. See \link[shiny:dateInput]{shiny::dateInput} for format
details.}

\item{startview}{The view shown when the textbox is first clicked. Can be
\code{"month"}, the default, for the usual monthly calendar view, \code{"year"},
or \code{"decade"}.}

\item{weekstart}{Which day is the start of the week; an integer from 0
(Sunday) to 6 (Saturday).}

\item{language}{The language used for month and day names, with \code{"en"}
(English) as the default. See \link[shiny:dateInput]{shiny::dateInput} for options.}

\item{autoclose}{Whether to close the calendar once a date has been
selected.}

\item{datesdisabled}{Dates that should be disabled (a character or Date
vector). Strings should be in the \code{"yyyy-mm-dd"} format.}

\item{daysofweekdisabled}{Days of the week that should be disabled; an
integer vector in which 0 is Sunday, and 6 is Saturday.}
}
\value{
An inline widget to be included in an \code{\link[=inline]{inline()}} wrapper.
}
\description{
A date input with a calendar pop-up similar to \code{\link[shiny:dateInput]{shiny::dateInput()}} that
can be included in an \code{\link[=inline]{inline()}} wrapper.
}
\examples{
ui <- bslib::page_fixed(
    shiny::h1("Select a date"),
    inline("Run simulation starting on ",
        inline_date("start_date", NULL, meaning = "Simulation start date",
            format = "dd/mm/yyyy", daysofweekdisabled = c(0, 6)),
        " (weekdays only)."
    )
)
}
\seealso{
\link[shiny:dateInput]{shiny::dateInput} for how the date input works with your Shiny server.
}
