% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_title.R
\name{split_title}
\alias{split_title}
\title{Split the title column in several columns}
\usage{
split_title(df, title_col_name, n_split = "max", lang = "en")
}
\arguments{
\item{df}{a dataframe containing a title column}

\item{title_col_name}{the column name to be splitted, if missing it will be either TITLE_EN}

\item{n_split}{number of new columns, by default the maximum is chosen}

\item{lang}{by default it returns an English title (its default value is "en"), any other value returns a French title}
}
\value{
the same dataframe with the title column splitted
}
\description{
Split the title column in several columns
}
\details{
The number of separators in the official INSEE title can vary and is not normalized. Beware all title columns created may not be a cleaned dimension label.
}
\examples{
\donttest{
library(tidyverse)

# quarterly payroll enrollment in the construction sector
data_raw = get_insee_idbank("001577236")

data = data_raw \%>\%
  split_title(lang = "fr")
}
}
