% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonomy.R
\name{get_taxID}
\alias{get_taxID}
\title{Get taxon ID from taxonomy database.}
\usage{
get_taxID(lineage, db, multimatch = NA)
}
\arguments{
\item{lineage}{character vector of taxon names or semicolon-delimited
lineage strings.}

\item{db}{a valid taxonomy database (as a data.frame object).
See \code{\link{taxonomy}} for details.}

\item{multimatch}{integer giving the value to return if the query
matches multiple entries. Defaults to NA_integer_.}
}
\value{
An integer giving the unique taxon ID,
  or NA if the taxon is not found in the database.
}
\description{
This function returns the unique ID for a specified taxon name by looking
  up a taxonomy database.
}
\examples{
data(whale_taxonomy)
get_taxID("Odontoceti", db = whale_taxonomy)
}
\references{
Federhen S (2012) The NCBI Taxonomy database.
 \emph{Nucleic Acids Research}
 \strong{40}, D136-D143. doi:10.1093/nar/gkr1178.

 \url{https://www.ncbi.nlm.nih.gov/taxonomy/}
}
\author{
Shaun Wilkinson
}
