% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strategies.R
\name{random_initialization}
\alias{random_initialization}
\title{Random initialization}
\usage{
random_initialization(
  x,
  runs = 1L,
  sampler = function() stats::rnorm(npar(x)),
  ncores = getOption("ino_ncores"),
  verbose = getOption("ino_progress"),
  label = "random"
)
}
\arguments{
\item{x}{An object of class \code{ino}.}

\item{runs}{An integer, the number of random initializations.
The default is \code{1}.}

\item{sampler}{A function without any arguments which returns a numeric vector of length
\code{npar(x)} with (random) initial values.
Per default, \code{sampler = function() stats::rnorm(npar(x))}, i.e. random
initial values from a standard normal distribution.}

\item{ncores}{The number of cores for parallel computation over parameters and optimizers.
The default is \code{getOption("ino_ncores")}, which is set to \code{1}
when the package is loaded.}

\item{verbose}{A boolean, which indicates whether progress should be printed.
Set to \code{TRUE} (\code{FALSE}) to print (hide) progress.
The default is \code{getOption("ino_progress")}, which is set to \code{TRUE}
when the package is loaded.}

\item{label}{A character, the label for the initialization strategy.}
}
\value{
The updated \code{ino} object.
}
\description{
This function is an implementation of the random initialization strategy.
}
\seealso{
\code{\link[=npar]{npar()}} to extract the number \code{npar} from an \code{ino} object.
}
\keyword{strategy}
