% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmesher_mesh.R
\name{fm_centroids}
\alias{fm_centroids}
\title{Extract triangle centroids from an \code{inla.mesh}}
\usage{
fm_centroids(x, format = NULL)
}
\arguments{
\item{x}{An \code{inla.mesh} object.}

\item{format}{character; \code{"sf"}, \code{"df"}, \code{"sp"}}
}
\value{
An \code{sf}, \code{data.frame}, or \code{SpatialPointsDataFrame} object, with the vertex
coordinates, and a \code{.triangle} column with the triangle indices.
}
\description{
Computes the centroids of the triangles of an \code{inla.mesh}
object.
}
\examples{
\donttest{
if (require(ggplot2, quietly = TRUE)) {
  data("mrsea", package = "inlabru")
  vrt <- fm_centroids(mrsea$mesh, format = "sp")
  ggplot() +
    gg(mrsea$mesh) +
    gg(vrt, color = "red")
}
}

}
\seealso{
\code{\link[=fm_vertices]{fm_vertices()}}
}
\author{
Finn Lindgren \email{finn.lindgren@gmail.com}
}
