% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mappers.R
\name{bru_mapper_taylor}
\alias{bru_mapper_taylor}
\alias{ibm_n.bru_mapper_taylor}
\alias{ibm_n_output.bru_mapper_taylor}
\alias{ibm_values.bru_mapper_taylor}
\alias{ibm_jacobian.bru_mapper_taylor}
\alias{ibm_eval.bru_mapper_taylor}
\title{Mapper for linear Taylor approximations}
\usage{
bru_mapper_taylor(
  offset = NULL,
  jacobian = NULL,
  state0 = NULL,
  values_mapper = NULL
)

\method{ibm_n}{bru_mapper_taylor}(mapper, inla_f = FALSE, multi = FALSE, ...)

\method{ibm_n_output}{bru_mapper_taylor}(mapper, input, ...)

\method{ibm_values}{bru_mapper_taylor}(mapper, inla_f = FALSE, multi = FALSE, ...)

\method{ibm_jacobian}{bru_mapper_taylor}(mapper, ..., multi = FALSE)

\method{ibm_eval}{bru_mapper_taylor}(mapper, input = NULL, state = NULL, ...)
}
\arguments{
\item{offset}{For \code{bru_mapper_taylor}, an offset vector evaluated
at \code{state0}.
May be \code{NULL}, interpreted as an all-zero vector of length determined by
a non-null Jacobian.}

\item{jacobian}{For \code{bru_mapper_taylor()}, the Jacobian matrix,
evaluated at \code{state0}, or, a named list of such matrices.
May be \code{NULL} or an empty list, for a constant mapping.}

\item{state0}{For \code{bru_mapper_taylor}, the state the linearisation
was evaluated at, or a list of length matching the \code{jacobian} list.
\code{NULL} is interpreted as 0.}

\item{values_mapper}{mapper object to be used for \code{ibm_n} and
\code{ibm_values} for \code{inla_f=TRUE} (experimental, currently unused)}

\item{mapper}{A mapper S3 object, inheriting from \code{bru_mapper}.}

\item{inla_f}{logical; when \code{TRUE} for \code{ibm_n()} and \code{ibm_values()}, the
result must be compatible with the \code{INLA::f(...)} and corresponding
\code{INLA::inla.stack(...)} constructions.  For \verb{ibm_\{eval,jacobian,linear\}},
the \code{input} interpretation may be different.
Implementations do not normally need to do anything different, except
for mappers of the type needed for hidden multicomponent models such
as "bym2", which can be handled by \code{bru_mapper_collect}.}

\item{multi}{logical;
If \code{TRUE} (or positive), recurse one level into sub-mappers}

\item{...}{Arguments passed on to other methods}

\item{input}{Data input for the mapper.}

\item{state}{A vector of latent state values for the mapping,
of length \code{ibm_n(mapper, inla_f = FALSE)}}
}
\description{
Provides a pre-computed affine mapping,
internally used to represent and evaluate linearisation information.
The \code{state0} information indicates for which state the \code{offset} was evaluated;
The affine mapper output is defined as
\code{effect(state) = offset + jacobian \%*\% (state - state0)}
}
\details{
\itemize{
\item The \code{ibm_eval.bru_mapper_taylor()} evaluates linearised
mapper information at the given \code{state}. The \code{input} argument is ignored,
so that the usual argument order
\code{ibm_eval(mapper, input, state)} syntax can be used, but also
\code{ibm_eval(mapper, state = state)}.  For a mapper with a named jacobian list,
the \code{state} argument must also be a named list.  If \code{state} is \code{NULL},
all-zero is assumed.
}
}
\examples{
m <- bru_mapper_taylor(
  offset = rep(2, 3),
  jacobian = matrix(1:6, 3, 2),
  state0 = c(1, 2)
)
ibm_eval2(m, state = 2:3)
}
\seealso{
\link{bru_mapper}, \link{bru_mapper_generics}

Other mappers: 
\code{\link{bru_get_mapper}()},
\code{\link{bru_mapper}()},
\code{\link{bru_mapper.fm_mesh_1d}()},
\code{\link{bru_mapper.fm_mesh_2d}()},
\code{\link{bru_mapper_aggregate}()},
\code{\link{bru_mapper_collect}()},
\code{\link{bru_mapper_const}()},
\code{\link{bru_mapper_factor}()},
\code{\link{bru_mapper_generics}},
\code{\link{bru_mapper_harmonics}()},
\code{\link{bru_mapper_index}()},
\code{\link{bru_mapper_linear}()},
\code{\link{bru_mapper_logsumexp}()},
\code{\link{bru_mapper_marginal}()},
\code{\link{bru_mapper_matrix}()},
\code{\link{bru_mapper_mesh_B}()},
\code{\link{bru_mapper_multi}()},
\code{\link{bru_mapper_pipe}()},
\code{\link{bru_mapper_scale}()},
\code{\link{bru_mapper_shift}()}
}
\concept{mappers}
