% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bru.inference.R
\name{bru_used}
\alias{bru_used}
\alias{bru_used.default}
\alias{bru_used.character}
\alias{bru_used.expression}
\alias{bru_used.formula}
\alias{bru_used.bru}
\alias{bru_used.list}
\alias{bru_used.bru_like}
\alias{bru_used.bru_used}
\alias{print.bru_used}
\title{List components used in a model}
\usage{
bru_used(x = NULL, ...)

\method{bru_used}{default}(
  x = NULL,
  ...,
  effect = NULL,
  effect_exclude = NULL,
  latent = NULL,
  labels = NULL
)

\method{bru_used}{character}(
  x,
  ...,
  effect = NULL,
  effect_exclude = NULL,
  latent = NULL,
  labels = NULL
)

\method{bru_used}{expression}(
  x,
  ...,
  effect = NULL,
  effect_exclude = NULL,
  latent = NULL,
  labels = NULL
)

\method{bru_used}{formula}(
  x,
  ...,
  effect = NULL,
  effect_exclude = NULL,
  latent = NULL,
  labels = NULL
)

\method{bru_used}{bru}(x, ..., join = TRUE)

\method{bru_used}{list}(x, ..., join = TRUE)

\method{bru_used}{bru_like}(x, ...)

\method{bru_used}{bru_used}(x, labels = NULL, ...)

\method{print}{bru_used}(x, ...)
}
\arguments{
\item{x}{An object that contains information about used components}

\item{...}{Parameters passed on to the other methods}

\item{effect}{character; components used as effects. When \code{NULL}, auto-detect
components to include or include all components.}

\item{effect_exclude}{character; components to specifically exclude from
effect evaluation. When \code{NULL}, do not specifically exclude any components.}

\item{latent}{character; components used as \verb{_latent} or \verb{_eval()}. When
\code{NULL}, auto-detect components.}

\item{labels}{character; component labels passed on to
\code{\link[=bru_used_update]{bru_used_update()}}}

\item{join}{Whether to join list output into a single object; Default
may depend on the input object class}
}
\value{
A \code{bru_used} object (a list with elements \code{effect}
and \code{latent}), or a list of such objects
(for methods with \code{join = FALSE})
}
\description{
Create or extract information about which components are used by a model, or
its individual observation models. If a non-NULL \code{labels} argument is
supplied, also calls \code{\link[=bru_used_update]{bru_used_update()}} on the \code{bru_used} objects.
}
\section{Methods (by class)}{
\itemize{
\item \code{bru_used(default)}: Create a \code{bru_used} object.

\item \code{bru_used(character)}: Create a \code{bru_used} object from a \code{character}
representation of an expression.

\item \code{bru_used(expression)}: Create a \code{bru_used} object from an expression object.

\item \code{bru_used(formula)}: Create a \code{bru_used} object from a formula (only the
right-hand side is used).

\item \code{bru_used(bru_used)}: Convenience method that takes
an existing \code{bru_used} object and calls \code{\link[=bru_used_update]{bru_used_update()}}
if \code{labels} is non-NULL.

}}
\section{Methods (by generic)}{
\itemize{
\item \code{print(bru_used)}: Print method for \code{bru_used} objects.

}}
\examples{
(used <- bru_used(~.))
bru_used(used, labels = c("a", "c"))
(used <- bru_used(~ a + b + c_latent + d_latent))
bru_used(used, labels = c("a", "c"))
(used <- bru_used(expression(a + b + c_latent + d_latent)))
bru_used(used, labels = c("a", "c"))

}
\seealso{
Other bru_used: 
\code{\link{bru_used_update}()},
\code{\link{bru_used_vars}()}
}
\concept{bru_used}
\keyword{internal}
