% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ceteris_paribus.R
\name{plot.ceteris_paribus_explainer}
\alias{plot.ceteris_paribus_explainer}
\title{Plots Ceteris Paribus Profiles}
\usage{
\method{plot}{ceteris_paribus_explainer}(x, ..., size = 1, alpha = 1,
  color = "#46bac2", variable_type = "numerical", facet_ncol = NULL,
  variables = NULL)
}
\arguments{
\item{x}{a ceteris paribus explainer produced with function \code{ceteris_paribus()}}

\item{...}{other explainers that shall be plotted together}

\item{size}{a numeric. Size of lines to be plotted}

\item{alpha}{a numeric between 0 and 1. Opacity of lines}

\item{color}{a character. Either name of a color or name of a variable that should be used for coloring}

\item{variable_type}{a character. If "numerical" then only numerical variables will be plotted.
If "categorical" then only categorical variables will be plotted.}

\item{facet_ncol}{number of columns for the \code{\link[ggplot2]{facet_wrap}}}

\item{variables}{if not \code{NULL} then only \code{variables} will be presented}
}
\value{
a \code{ggplot2} object
}
\description{
Function \code{plot.ceteris_paribus_explainer} plots Individual Variable Profiles for selected observations.
Various parameters help to decide what should be plotted, profiles, aggregated profiles, points or rugs.

Find more detailes in \href{https://pbiecek.github.io/PM_VEE/ceterisParibus.html}{Ceteris Paribus Chapter}.
}
\examples{
library("DALEX")

titanic <- na.omit(titanic)

model_titanic_glm <- glm(survived == "yes" ~ gender + age + fare,
                         data = titanic, family = "binomial")

explain_titanic_glm <- explain(model_titanic_glm,
                               data = titanic[,-9],
                               y = titanic$survived == "yes",
                               verbose = FALSE)

cp_rf <- ceteris_paribus(explain_titanic_glm, titanic[1,])
cp_rf

plot(cp_rf, variables = "age")

\donttest{
library("randomForest")
model_titanic_rf <- randomForest(survived == "yes" ~ gender + age + class + embarked +
                                 fare + sibsp + parch,  data = titanic)

explain_titanic_rf <- explain(model_titanic_rf,
                              data = titanic[,-9],
                              y = titanic$survived == "yes",
                              label = "Random Forest v7",
                              verbose = FALSE)

selected_passangers <- select_sample(titanic, n = 100)

cp_rf <- ceteris_paribus(explain_titanic_rf, selected_passangers)
cp_rf

plot(cp_rf, variables = "age") +
  show_observations(cp_rf, variables = "age") +
  show_rugs(cp_rf, variables = "age", color = "red")

selected_passangers <- select_sample(titanic, n = 1)
selected_passangers

cp_rf <- ceteris_paribus(explain_titanic_rf, selected_passangers)

plot(cp_rf) +
  show_observations(cp_rf)

plot(cp_rf, variables = "age") +
  show_observations(cp_rf, variables = "age")

plot(cp_rf, variables = "class")
plot(cp_rf, variables = c("class", "embarked"), facet_ncol = 1)
plot(cp_rf, variables = c("class", "embarked", "gender", "sibsp"), variable_type = "categorical")

}
}
\references{
Predictive Models: Visual Exploration, Explanation and Debugging \url{https://pbiecek.github.io/PM_VEE}
}
