% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partial_dependency.R
\name{partial_dependency}
\alias{partial_dependency}
\alias{partial_dependency.explainer}
\alias{partial_dependency.default}
\alias{partial_dependency.ceteris_paribus_explainer}
\title{Partial Dependency Profiles}
\usage{
partial_dependency(x, ...)

\method{partial_dependency}{explainer}(x, variables = NULL, N = 500,
  variable_splits = NULL, grid_points = 101, ...,
  variable_type = "numerical")

\method{partial_dependency}{default}(x, data, predict_function = predict,
  label = class(x)[1], variables = NULL, grid_points = 101,
  variable_splits = NULL, N = 500, ..., variable_type = "numerical")

\method{partial_dependency}{ceteris_paribus_explainer}(x, ...,
  variables = NULL)
}
\arguments{
\item{x}{an explainer created with function \code{DALEX::explain()}, an object of the class \code{ceteris_paribus_explainer} or
or a model to be explained.}

\item{...}{other parameters}

\item{variables}{names of variables for which profiles shall be calculated.
Will be passed to \code{\link{calculate_variable_split}}.
If \code{NULL} then all variables from the validation data will be used.}

\item{N}{number of observations used for calculation of partial dependency profiles. By default 500.}

\item{variable_splits}{named list of splits for variables, in most cases created with \code{\link{calculate_variable_split}}.
If \code{NULL} then it will be calculated based on validation data avaliable in the \code{explainer}.}

\item{grid_points}{number of points for profile. Will be passed to \code{\link{calculate_variable_split}}.}

\item{variable_type}{a character. If "numerical" then only numerical variables will be calculated.
If "categorical" then only categorical variables will be calculated.}

\item{data}{validation dataset, will be extracted from \code{x} if it's an explainer
NOTE: It is best when target variable is not present in the \code{data}}

\item{predict_function}{predict function, will be extracted from \code{x} if it's an explainer}

\item{label}{name of the model. By default it's extracted from the \code{class} attribute of the model}
}
\value{
an object of the class \code{aggregated_profiles_explainer}
}
\description{
Partial Dependency Profiles are averages from Ceteris Paribus Profiles.
Function 'partial_dependency' calls 'ceteris_paribus' and then 'aggregate_profiles'.
}
\details{
Find more detailes in the \href{https://pbiecek.github.io/PM_VEE/partialDependenceProfiles.html}{Partial Dependence Profiles Chapter}.
}
\examples{
library("DALEX")

titanic_imputed$country <- NULL

model_titanic_glm <- glm(survived == "yes" ~ gender + age + fare,
                         data = titanic_imputed, family = "binomial")

explain_titanic_glm <- explain(model_titanic_glm,
                               data = titanic_imputed[,-8],
                               y = titanic_imputed$survived == "yes",
                               verbose = FALSE)

pdp_glm <- partial_dependency(explain_titanic_glm,
                              N = 50, variables = c("age", "fare"))
head(pdp_glm)
plot(pdp_glm)

\donttest{
library("randomForest")

model_titanic_rf <- randomForest(survived == "yes" ~.,  data = titanic_imputed)

explain_titanic_rf <- explain(model_titanic_rf,
                              data = titanic_imputed[,-8],
                              y = titanic_imputed$survived == "yes",
                              verbose = FALSE)

pdp_rf <- partial_dependency(explain_titanic_rf, variable_type = "numerical")
plot(pdp_rf)

pdp_rf <- partial_dependency(explain_titanic_rf, variable_type = "categorical")
plotD3(pdp_rf, variable_type = "categorical", label_margin = 80, scale_plot = TRUE)
}

}
\references{
Predictive Models: Visual Exploration, Explanation and Debugging \url{https://pbiecek.github.io/PM_VEE}
}
