\name{infoDecompMat}
\alias{infoDecompMat}
\title{
Construct the Matrix from Information Decomposition
}
\description{
Perform the information decomposition for either the block or treatment effects within a single stratum.
}
\usage{
infoDecompMat(z, T, N)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{z}{
a matrix containing the orthogonal projector for a single stratum generated by \code{\link{makeOrthProjectors}}.
}
  \item{T}{
a list of contrast matrices generated by \code{\link{makeContrMat}}.
}
  \item{N}{
a matrix containing the design matrix generated by \code{\link{makeOverDesMat}}.
}     
}
\value{
A list of matrices.
}
\details{
The main purpose of this function is to construct a list of resultant matrices associated with each source of variation after the information decomposition. 

This list of matrices are then used to compute the coefficient of the variance components in the expected mean squares.   
}

\author{
Kevin Chang
}
\examples{
design1 <- local({ 
  Ani = as.factor(LETTERS[c(1,2,3,4,
                            5,6,7,8)])
  Trt = as.factor(letters[c(1,1,1,1,
                            2,2,2,2)])
  data.frame(Ani, Trt)
})

blk.str = "Ani"
    
rT = terms(as.formula(paste("~", blk.str, sep = "")), keep.order = TRUE) 
blkTerm = attr(rT,"term.labels")
     
Z = makeBlkDesMat(design1, blkTerm)
Pb = makeOrthProjectors(Z)

trt.str = "Trt"              
fT <- terms(as.formula(paste("~", trt.str, sep = "")), keep.order = TRUE)  #fixed terms

trtTerm <- attr(fT, "term.labels")
effectsMatrix <- attr(fT, "factor")        

T <- makeContrMat(design1, trtTerm, effectsMatrix, contr.vec = NA)

N =  makeOverDesMat(design1, trtTerm)


infoDecompMat(Pb[[1]], T, N)

}

