% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{ihs}
\alias{ihs}
\alias{IHS}
\title{Integrated hubness score (IHS)}
\usage{
ihs(DC, BC, NC)
}
\arguments{
\item{DC}{A vector containing the values of degree centrality of the desired vertices.}

\item{BC}{A vector containing the values of betweenness centrality of the desired vertices.}

\item{NC}{A vector containing the values of neighborhood connectivity of the desired vertices.}
}
\value{
A numeric vector with the IHS score based on the provided centrality measures.
}
\description{
This function calculates the IHS of the desired nodes. This function is not dependent to
other packages and the required centrality measures, namely degree centrality, betweenness
centrality and neighborhood connectivity could have been calculated by any means beforehand.
}
\examples{
MyData <- centrality.measures
My.vertices.IHS <- ihs(DC = centrality.measures$Degree,
                       BC = centrality.measures$BetweennessCentrality,
                       NC = centrality.measures$NeighborhoodConnectivity)
}
\keyword{IHS}
\keyword{integrated_hubness_score}
