% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/OtrosIndicadores.R
\name{series_crecimiento_regiones}
\alias{series_crecimiento_regiones}
\title{Obtiene indicador de actividad por zona}
\usage{
series_crecimiento_regiones(token)
}
\arguments{
\item{token}{token personal emitido por el INEGI para acceder al API.}
}
\value{
Data.frame
}
\description{
Obtiene índice de PIB por zona geográfica.
Este es un wrapper de \code{serie_inegi()}, con una metodología propia de En El Margen, se puede consultar la misma aquí: \url{http://enelmargen.org/eem/regiones/}.
El crecimiento del mismo es una estimación de la dinámica de crecimiento regional nacional, inspirado en \url{http://www.banxico.org.mx/publicaciones-y-discursos/publicaciones/informes-periodicos/reportes-sobre-las-economias-regionales/{1C8EFC32-C12C-8393-6C29-5AF0A7F45686}.pdf}.
Los agrupamientos regionales provienen del INEGI \url{http://www.inegi.org.mx/est/contenidos/proyectos/cn/itaee/default.aspx}
}
\examples{
\dontrun{
token<-"webservice_token"
CrecimientoZonas<-series_crecimiento_regiones(token)
}
}
\author{
Eduardo Flores
}
\seealso{
series_PIB_estados, crecer, series_ITAE_estados
}

