% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.R
\name{subset.incidence}
\alias{subset.incidence}
\alias{"subset.incidence"}
\alias{"[.incidence"}
\alias{[.incidence}
\title{Subsetting 'incidence' objects}
\usage{
\method{subset}{incidence}(x, ..., from = min(x$dates), to = max(x$dates),
  groups = TRUE)

\method{[}{incidence}(x, i, j)
}
\arguments{
\item{x}{An incidence object, generated by the function
\code{\link{incidence}}.}

\item{...}{Further arguments passed to other methods (not used).}

\item{from}{The starting date; data strictly before this date are discarded.}

\item{to}{The ending date; data strictly after this date are discarded.}

\item{groups}{(optional) The groups to retained, indicated as subsets of the
columns of x$counts.}

\item{i}{a subset of dates to retain}

\item{j}{a subset of groups to retain}
}
\description{
Two functions can be used to subset incidence objects.  The function
\code{subset} permits to retain dates within a specified range and,
optionally, specific groups. The operator "[" can be used as for matrices,
using the syntax \code{x[i,j]} where 'i' is a subset of dates, and 'j' is a
subset of groups.
}
\examples{
## example using simulated dataset
if(require(outbreaks)) {
  onset <- ebola_sim$linelist$date.of.onset

  ## weekly incidence
  inc <- incidence(onset, interval = 7)
  inc
  inc[1:10] # first 10 weeks
  plot(inc[1:10])
  inc[-c(11:15)] # remove weeks 11-15
  plot(inc[-c(11:15)])
}

}
\seealso{
The \code{\link{incidence}} function to generate the 'incidence'
objects.
}
\author{
Thibaut Jombart \email{thibautjombart@gmail.com}
}
