% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversion.R
\name{as.data.frame.incidence}
\alias{as.data.frame.incidence}
\title{Conversion of indence objects}
\usage{
\method{as.data.frame}{incidence}(x, ..., long = FALSE)
}
\arguments{
\item{x}{An \code{incidence} object.}

\item{...}{Further arguments passed to other functions (no used).}

\item{long}{A logical indicating if the output data.frame should be 'long', i.e. where a single
column containing 'groups' is added in case of data computed on several groups.}
}
\description{
These functions convert \code{incidence} objects into other classes.
}
\examples{
## create fake data
data <- c(0,1,1,2,1,3,4,5,5,5,5,4,4,26,6,7,9)
sex <- sample(c("m","f"), length(data), replace=TRUE)

## get incidence per group (sex)
i <- incidence(data, groups = sex)
i
plot(i)

## convert to data.frame
as.data.frame(i)

## same, 'long format'
as.data.frame(i, long = TRUE)

}
\author{
Thibaut Jombart \email{thibautjombart@gmail.com}, Rich Fitzjohn
}
\seealso{
the \code{\link{incidence}} function to generate the 'incidence' objects.
}

