% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/resample_g2.R
\name{resample_g2}
\alias{resample_g2}
\title{Identity disequilibrium (g2) for different subsets of markers}
\usage{
resample_g2(genotypes, subsets = NULL, nboot = 100, type = c("msats",
  "snps"), parallel = FALSE, ncores = NULL)
}
\arguments{
\item{genotypes}{data.frame with individuals in rows and loci in columns,
containing genotypes coded as 0 (homozygote), 1 (heterozygote) and NA (missing)}

\item{subsets}{a vector specifying the sizes of subsets to draw. For a subset of 20 markers, subsets = c(2, 5, 10, 15, 20) could
be a reasonable choice. The minimum subset size is 2 and the maximum is the number of markers in the data.}

\item{nboot}{number of re-draws per subset size.}

\item{type}{specifies g2 formula to take. Type "snps" for large datasets and "msats" for smaller datasets.}

\item{parallel}{Default is FALSE. If TRUE, resamplings are parallelized}

\item{ncores}{Specify number of cores to use for parallelization. By default,
       all available cores are used.}
}
\value{
\item{call}{function call.}
\item{g2_full}{g2 estimate for the full marker set}
\item{all_g2_res}{vector of g2 values for each randomly subsetted dataset}
\item{summary_exp_r2}{g2 mean and sd for each number of subsetted loci}
\item{nobs}{number of observations}
\item{nloc}{number of markers}
}
\description{
Identity disequilibrium (g2) for different subsets of markers
}
\examples{
data(mouse_msats)
genotypes <- convert_raw(mouse_msats)
(out <- resample_g2(genotypes, subsets = c(2,4,6,8,10,12), nboot = 1000, type = "msats"))
plot(out)
}
\author{
Martin A. Stoffel (martin.adam.stoffel@gmail.com)
}
\references{
Hoffman, J.I., Simpson, F., David, P., Rijks, J.M., Kuiken, T., Thorne, M.A.S., Lacey, R.C. & Dasmahapatra, K.K. (2014) High-throughput sequencing reveals inbreeding depression in a natural population.
Proceedings of the National Academy of Sciences of the United States of America, 111: 3775-3780. Doi: 10.1073/pnas.1318945111
}

