% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryTable-combine.R
\name{combine.summaryTable}
\alias{combine.summaryTable}
\title{Combine summary statistics table}
\usage{
\method{combine}{summaryTable}(..., summaryTables, combineVar = NULL, combineDir = c("row", "col"))
}
\arguments{
\item{...}{\code{\link{summaryTable}} objects.}

\item{summaryTables}{List of \code{\link{summaryTable}} objects.}

\item{combineVar}{(optional) String with name
of a new variable tracking from which table
each record originally come from.\cr
The label for each table is extracted from the names
of the \code{summaryTables} list, or 1:length(tables)
if the list is not named.\cr
If not specified (by default), the tables will be combined
but the information on which input table:
each record from the combined table belongs to will
not be retained.}

\item{combineDir}{String indicating
on which direction: 'row' or 'col' (a.k.a column)
the information on the table appartenance 
(\code{combineVar}) will
be displayed when the table is exported.}
}
\value{
A combined \code{\link{summaryTable}}.
}
\description{
\itemize{
\item{A new table is created, combining the tables by rows.}
\item{The attributes of the combined summary table are 
obtained by combining the attributes of all summary tables
(and removing duplicates).}
}
}
\details{
\itemize{
\item{In case only a set of tables contain categorical variable,
in nested rows, so the \code{variable} and \code{variableGroup}
variables, these variables are included as last in 
the 'row variables' attribute of the combined table.}
\item{Only one row is retained for the columns totals
per column variable (the first one in order of appearance).\cr
The column totals are not included if the column
variable(s) are not the same across tables, or
if the totals differ between tables.}
}
}
\examples{
# load example data
library(clinUtils)
data(dataADaMCDISCP01)

dataSL <- dataADaMCDISCP01$ADSL
labelVars <- attr(dataADaMCDISCP01, "labelVars")

## Summary tables can be combined next to each other
# for example to combine summary tables from multiple
# studies with different compounds:
varsSL <- c("HEIGHTBL", "WEIGHTBL", "BMIBL")

# study with low dose of the compound
summaryTableXanoLow <- computeSummaryStatisticsTable(
	data = subset(dataSL, TRT01P == "Xanomeline Low Dose"),
	var = varsSL,
	stats = getStats(c("n", "median (range)")),
	labelVars = labelVars
)
# study with high dose of the compound
summaryTableXanoHigh <- computeSummaryStatisticsTable(
	data = subset(dataSL, TRT01P == "Xanomeline High Dose"),
	var = varsSL,
	stats = getStats(c("n", "median (range)")),
	labelVars = labelVars
)
summaryTable <- combine(
	`Low dose` = summaryTableXanoLow, 
	`High dose` = summaryTableXanoHigh,
	combineVar = "Treatment",
	combineDir = "col"
)
export(summaryTable)

## Summary tables with different set statistics
# and variables can be combined as well
# This can specify the specification of the parameters

# demography table with categorical variables
summaryTableCat <- computeSummaryStatisticsTable(
	data = dataSL,
	var = c("HEIGHTBL", "WEIGHTBL", "BMIBL", "AGE"),
	colVar = "TRT01P",
	stats = getStats(c("n", "median (range)")),
	labelVars = labelVars
)
# demography table with continuous variables
summaryTableCont <- computeSummaryStatisticsTable(
	data = dataSL,
	var = c("SEX", "RACE", "ETHNIC"),
	colVar = "TRT01P",
	stats = getStats("n (\%)", includeName = FALSE),
	varInclude0 = TRUE,
	labelVars = labelVars
)
summaryTable <- combine(summaryTableCat, summaryTableCont)
export(summaryTable)
}
\author{
Laure Cougnaud
}
