% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na.interpolation.R
\name{na.interpolation}
\alias{na.interpolation}
\title{Missing Value Imputation by Interpolation}
\usage{
na.interpolation(data, option = "linear", na.identifier = NA)
}
\arguments{
\item{data}{Time Series (\code{\link{ts}}) object in which missing values are to be replaced}

\item{option}{Algorithm to be used. Accepts the following input:
\itemize{
   \item{"linear" - for linear interpolation}
   \item{"spline" - for spline interpolation}
   }}

\item{na.identifier}{Missing Value Identifier. 
If another value than NA indicates missing values this can be specified here. 
Identifier can be a character string as well as a numeric value. No support for lists or vectors.}
}
\value{
Time Series (\code{\link{ts}}) object
}
\description{
Uses either linear or spline interpolation to replace missing values.
}
\details{
Missing values get replaced by values of a \link{approx} or \link{spline} interpolation.
 Both functions are thereby called with their default parameters (except for parameter rule at approx, which is set to 2)
 If more flexibility in parameter settings is needed, na.approx / na.spline from the \pkg{zoo} 
 package can be a option.
}
\examples{
#Create Time series with missing values
x <- ts(c(2,3,4,5,6,NA,7,8))

#Perform linear interpolation
na.interpolation(x)

#Perform spline interpolation
na.interpolation(x, option ="spline")

}
\author{
Steffen Moritz
}
\seealso{
\code{\link[imputeTS]{na.mean}}, \code{\link[imputeTS]{na.locf}},
 \code{\link[imputeTS]{na.random}}, \code{\link[imputeTS]{na.replace}}
}

