% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/censo_municipal.R
\name{censo_municipal}
\alias{censo_municipal}
\title{Censo Nacional de Gobiernos Municipales y Delegacionales}
\usage{
censo_municipal(year = NA, fuente = NA, datos = NA)
}
\arguments{
\item{year}{Año del levantamiento del censo en formato numerico. Los años disponibles son 2011, 2013, 2015 y 2017.}

\item{fuente}{Fuente de datos de las instituciones publicas de municipales y delegacionales en formato alfanumerico. Las opciones son: ayuntamiento, administracion, seguridad, justicia.}

\item{datos}{Base de datos producida por cada fuente de datos en formato alfanumerico. Las opciones pueden ser, segun la fuente de datos: comision, estructura, integrantes, actividades, funciones, marco, participacion, recursos, tramites, transparencia, ejercicio, infraestructura, y recursos.}
}
\value{
Data.frame
}
\description{
Descarga los datos del Censo Nacional de Gobiernos Municipales y Delegacionales (CNGMD),
}
\details{
El CNGMD es un proyecto estadistico sobre la gestion y desempeño de las entidades gubernamentales mexicanas a nivel municipal. El CNGMD cubre cuatro tematicas: ayuntamiento, administracion publica municipal, seguridad y justicia.
}
\examples{

# Consulta los metadatos del Censo Nacional de Gobiernos Municipales y Delegacionales
\dontrun{censo_municipal()}

# Descarga los microdatos de la estructura de los ayuntamientos en 2011
\dontrun{estruct <- censo_municipal(year = 2011, fuente = "ayuntamiento", datos = "estructura")}
}
