% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/implicitExpansion.R
\name{expandedDim}
\alias{expandedDim}
\title{Implied Dimension of a set of Arrays}
\usage{
expandedDim(..., arrays = list())
}
\arguments{
\item{...}{Objects that are coerced to arrays.}

\item{arrays}{A list of objects that are coerced to arrays.}
}
\value{
A numberical vector containing the expanded dimension implied by the arrays.
}
\description{
Get the dimension implied by a set of arrays as used in implicit expansion.
}
\details{
Both the arrays in \code{...} and \code{arrays} are considered by concatenating them with \code{c(list(...), arrays)}.
Throws an error if the arrays are not compatible.
}
\examples{
x <- 1:3
y <- t(4:5)
z <- array(0, c(1,1,6))
expandedDim(x, y, z)

}
\seealso{
\code{\link{expandArray}}
}
