% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{auto_simon_ml}
\alias{auto_simon_ml}
\title{Automated Machine Learning Model Building}
\usage{
auto_simon_ml(dataset_ml, settings)
}
\arguments{
\item{dataset_ml}{A data frame containing the dataset for training. All columns except the outcome
column should contain the features.}

\item{settings}{A list containing the following parameters:
\itemize{
\item{\code{outcome}}: A string specifying the name of the outcome column in \code{dataset_ml}. Defaults to "immunaut" if not provided.
\item{\code{excludedColumns}}: A vector of column names to be excluded from the training data. Defaults to \code{NULL}.
\item{\code{preProcessDataset}}: A vector of preprocessing steps to be applied (e.g., \code{c("center", "scale", "medianImpute")}). Defaults to \code{NULL}.
\item{\code{selectedPartitionSplit}}: A numeric value specifying the proportion of data to be used for training. Must be between 0 and 1. Defaults to 0.7.
\item{\code{selectedPackages}}: A character vector specifying the machine learning algorithms to be used for training (e.g., \code{"nb"}, \code{"rpart"}). Defaults to \code{c("nb", "rpart")}.
}}
}
\value{
A list where each element corresponds to a trained model for one of the algorithms specified in
\code{settings$selectedPackages}. Each element contains:
\itemize{
\item{\code{info}}: General information about the model, including resampling indices, problem type,
and outcome mapping.
\item{\code{training}}: The trained model object and variable importance.
\item{\code{predictions}}: Predictions on the test set, including probabilities, confusion matrix,
post-resample statistics, AUROC (for binary classification), and prAUC (for binary classification).
}
}
\description{
This function automates the process of building machine learning models using the caret package.
It supports both binary and multi-class classification and allows users to specify a list of
machine learning algorithms to be trained on the dataset. The function splits the dataset into
training and testing sets, applies preprocessing steps, and trains models using cross-validation.
It computes relevant performance metrics such as confusion matrix, AUROC (for binary classification),
and prAUC (for binary classification).
}
\details{
The function performs preprocessing (e.g., centering, scaling, and imputation of missing values) on the dataset based on the provided settings.
It splits the data into training and testing sets using the specified partition, trains models using cross-validation, and computes performance metrics.

For binary classification problems, the function calculates AUROC and prAUC. For multi-class classification, it calculates macro-averaged AUROC, though prAUC is not used.

The function returns a list of trained models along with their performance metrics, including confusion matrix, variable importance, and post-resample metrics.
}
\examples{
\dontrun{
# Example usage:
dataset_ml <- generate_demo_data(n_subjects = 1000, n_features = 200)
settings <- list(
  selectedPackages = c("nb", "rpart"),
  selectedPartitionSplit = 0.7
)
results <- auto_simon_ml(dataset_ml, settings)
}

}
