% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylip.R
\name{repClonalFamily}
\alias{repClonalFamily}
\title{Builds a phylogenetic tree using the sequences of a clonal lineage}
\usage{
repClonalFamily(.data, .threads, .nofail)
}
\arguments{
\item{.data}{The data to be processed, output of repAlignLineage() function.}

\item{.threads}{Number of threads to use.}

\item{.nofail}{Returns NA instead of stopping if PHYLIP is not installed.
Used to avoid raising errors in examples on computers where PHYLIP is not installed.}
}
\value{
Dataframe or list of dataframes (if input is a list with multiple samples).
The dataframe has these columns:
* Cluster: cluster name
* Germline.Input: germline sequence, like it was in the input; not aligned
* Germline.Output: germline sequence, parsed from PHYLIP dnapars function output;
  it contains difference of germline from the common ancestor; "." characters mean
  matching letters
* Common.Ancestor: common ancestor sequence, parsed from PHYLIP dnapars function output
* Trunk.Length: mean trunk length, representing the distance between the most recent
  common ancestor and germline sequence as a measure of the maturity of a lineage
* Tree: output tree in "phylo" format, loaded from by PHYLIP dnapars function output
* TreeStats: nested dataframe containing data about tree nodes, needed for visualization
* Sequences: nested dataframe containing all sequences for this combination of cluster
  and germline; it contains regions from original sequences, saved for
  repSomaticHypermutation() calculation, and also data needed for visualizations
}
\description{
This function uses the PHYLIP package to make phylogenetic analysis.
For making trees it uses maximum parsimony methods.
}
\examples{

data(bcrdata)
bcr_data <- bcrdata$data

bcr_data \%>\%
  seqCluster(seqDist(bcr_data), .fixed_threshold = 3) \%>\%
  repGermline(.threads = 1) \%>\%
  repAlignLineage(.min_lineage_sequences = 2, .align_threads = 2, .nofail = TRUE) \%>\%
  repClonalFamily(.threads = 1, .nofail = TRUE)
}
\concept{phylip}
