% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{apply_symm}
\alias{apply_symm}
\alias{apply_asymm}
\title{Apply function to each pair of data frames from a list.}
\usage{
apply_symm(.datalist, .fun, ..., .diag = NA, .verbose = TRUE)

apply_asymm(.datalist, .fun, ..., .diag = NA, .verbose = TRUE)
}
\arguments{
\item{.datalist}{List with some data.frames.}

\item{.fun}{Function to apply, which return basic class value.}

\item{...}{Arguments passsed to .fun.}

\item{.diag}{Either NA for NA or something else != NULL for .fun(x,x).}

\item{.verbose}{if TRUE then output a progress bar.}
}
\value{
Matrix with values M[i,j] = fun(datalist[i], datalist[j])
}
\description{
Apply the given function to every pair in the given datalist. Function either
symmetrical (i.e. fun(x,y) == fun(y,x)) or assymmetrical (i.e. fun(x,y) != fun(y,x)).
}
\examples{
data(immdata)
apply_symm(immdata$data, function(x, y) {
  nrow(x) + nrow(y)
})
}
\concept{utility_public}
