% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/germline.R
\name{repGermline}
\alias{repGermline}
\title{Creates germlines for clonal lineages}
\usage{
repGermline(.data,
.species, .align_j_gene, .min_nuc_outside_cdr3, .threads)
}
\arguments{
\item{.data}{The data to be processed. Can be \link{data.frame}, \link{data.table}
or a list of these objects.

It must have columns in the immunarch compatible format \link{immunarch_data_format}.}

\item{.species}{Species from which the data was acquired. Available options:
"HomoSapiens" (default), "MusMusculus", "BosTaurus", "CamelusDromedarius",
"CanisLupusFamiliaris", "DanioRerio", "MacacaMulatta", "MusMusculusDomesticus",
"MusMusculusCastaneus", "MusMusculusMolossinus", "MusMusculusMusculus", "MusSpretus",
"OncorhynchusMykiss", "OrnithorhynchusAnatinus", "OryctolagusCuniculus", "RattusNorvegicus",
"SusScrofa".}

\item{.align_j_gene}{MiXCR provides the number of J indels only for 1 allele of J gene
in the output file, and a germline can contain another allele. Therefore, calculation of
J gene start in reference based on numbers from input file can be sometimes incorrect.
As result, J gene in the germline will be trimmed in the start or will contain some
nucleotides from CDR3. Setting this parameter to TRUE enables precise alignment of J genes
to detect the correct starting point, but it significantly reduces performance.}

\item{.min_nuc_outside_cdr3}{This parameter sets how many nucleotides should have V or J chain
outside of CDR3 to be considered good for further alignment.}

\item{.threads}{Number of threads to use.}
}
\value{
Data with added columns:
* V.first.allele, J.first.allele (first alleles of V and J genes),
* V.ref.nt, J.ref.nt (V and J reference sequences),
* V.germline.nt, J.germline.nt (V and J germline sequences; they are references with
  trimmed parts that are from CDR3),
* CDR3.germline.length (length of CDR3 in the germline),
* Germline.sequence (combined germline sequence)
}
\description{
This function creates germlines for clonal lineages. B cell clonal lineage
represents a set of B cells that presumably have a common origin (arising from the same VDJ
rearrangement event) and a common ancestor. Each clonal lineage has its own germline sequence
that represents the ancestral sequence for each BCR in clonal lineage. In other words,
germline sequence is a sequence of B-cells immediately after VDJ recombination, before
B-cell maturation and hypermutation process. Germline sequence is useful for assessing
the degree of mutation and maturity of the repertoire.
}
\examples{

data(bcrdata)

bcrdata$data \%>\%
  top(5) \%>\%
  repGermline(.threads = 1)
}
\concept{germline}
