% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_density.R
\name{plot_density}
\alias{plot_density}
\title{plot_density}
\usage{
plot_density(result, drug, fill = "#6495ED")
}
\arguments{
\item{result}{an object of class ScoreResult.}

\item{drug}{a character of drug name.}

\item{fill}{fill color.}
}
\value{
a ggplot
}
\description{
Plot smoothed density estimates for adjusted score
}
\examples{
\dontrun{
  data("drugSample")
  FP <- extrFP(disease_biomarker = drugSample$disease_biomarker,
               drug_target = drugSample$herb_target,
               geneset = "ImmGenTop150")
  res <- score_fp(FP, n=100)
  plot_density(res, drug="BAN_XIA_XIE_XIN_TANG")
}
}
\author{
Yuanlong Hu
}
