% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ice.R
\name{plot.Ice}
\alias{plot.Ice}
\title{Plot ICE (Individual Conditional Expectation)}
\usage{
\method{plot}{Ice}(x)
}
\arguments{
\item{x}{An Ice R6 object}
}
\value{
ggplot2 plot object
}
\description{
plot.Ice() plots the individiual expectation results from an Ice object.
}
\examples{
if (require("randomForest")) {

data("Boston", package  = "MASS")
rf = randomForest(medv ~ ., data = Boston, ntree = 50)
mod = Predictor$new(rf, data = Boston)

# Compute the individual conditional expectations for the first feature
ice = Ice$new(mod, feature = "crim")

# Plot the results directly
plot(ice)
}
}
\seealso{
\link{Ice}
}
